/*
 * Decompiled with CFR 0.152.
 */
package util;

import controlador.Diagrama;
import controlador.Editor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import util.Arquivo;
import util.DlgExecutor;
import util.JFontChooser;
import util.PainelSelecaoCor;
import util.Utilidades;

public class Dialogos {
    public static Color c = Color.BLACK;
    private static String dir = "";
    public static JFontChooser JFC = new JFontChooser();

    public static int ShowMessageSave(Diagrama afechar) {
        String arq = afechar.getNomeFormatado();
        return JOptionPane.showConfirmDialog(afechar.getEditor().getParent(), Editor.fromConfiguracao.getValor("Controler.MSG_SAVE") + " " + arq, Editor.fromConfiguracao.getValor("Controler.MSG_SAVE_TITLE"), 1, 3);
    }

    public static int ShowMessageConfirm(Component parente, String txtAdicional) {
        if (parente != null) {
            parente.requestFocus();
        }
        return JOptionPane.showConfirmDialog(parente, Editor.fromConfiguracao.getValor("Controler.MSG_CONFIRM") + (txtAdicional.isEmpty() ? "?" : " " + txtAdicional), Editor.fromConfiguracao.getValor("Controler.MSG_CONFIRM_TITLE"), 0, 3);
    }

    public static int ShowMessageConfirm(Component parente, String msgTexto, boolean msgConfirm) {
        if (msgConfirm) {
            return Dialogos.ShowMessageConfirm(parente, msgTexto);
        }
        if (parente != null) {
            parente.requestFocus();
        }
        return JOptionPane.showConfirmDialog(parente, msgTexto.isEmpty() ? "?" : " " + msgTexto, Editor.fromConfiguracao.getValor("Controler.MSG_CONFIRM_TITLE"), 0, 3);
    }

    public static boolean ShowMessageConfirmYES(Component parente, String txtAdicional) {
        return Dialogos.ShowMessageConfirm(parente, txtAdicional) == 0;
    }

    public static boolean ShowMessageConfirmYES(Component parente, String txtAdicional, boolean msgConfirm) {
        return Dialogos.ShowMessageConfirm(parente, txtAdicional, msgConfirm) == 0;
    }

    public static void ShowMessageInform(Component parente, String texto) {
        JOptionPane.showMessageDialog(parente, texto, Editor.fromConfiguracao.getValor("Controler.MSG_INFORM_TITLE"), 1);
    }

    public static void ShowMessageERROR(Component parente, String texto) {
        JOptionPane.showMessageDialog(parente, texto, Editor.fromConfiguracao.getValor("Controler.MSG_ERROR_TITLE"), 0);
    }

    public static String ShowDlgTexto(JComponent form, String texto) {
        DlgExecutor dlg = new DlgExecutor((Frame)form.getParent(), true);
        dlg.Texto.setText(texto);
        dlg.setLocationRelativeTo(form);
        dlg.setVisible(true);
        if (dlg.getResultado() == 0) {
            return dlg.Texto.getText();
        }
        return texto;
    }

    public static String ShowDlgTexto(JComponent form, String texto, String original) {
        DlgExecutor dlg = new DlgExecutor((Frame)form.getParent(), true);
        dlg.Texto.setText(texto);
        dlg.setLocationRelativeTo(form);
        dlg.setVisible(true);
        if (dlg.getResultado() == 0) {
            return dlg.Texto.getText();
        }
        return original;
    }

    public static void ShowDlgTextoReadOnly(JComponent form, String texto) {
        DlgExecutor dlg = new DlgExecutor((Frame)form.getParent(), true);
        dlg.Texto.setText(texto);
        dlg.Texto.setEditable(false);
        dlg.Texto.setForeground(Color.DARK_GRAY);
        dlg.Texto.setCaretPosition(0);
        dlg.setLocationRelativeTo(form);
        dlg.btnCancelar.setVisible(false);
        dlg.setVisible(true);
    }

    public static String ShowDlgCor(JComponent form, String textoCor, Diagrama modelo) {
        try {
            c = Utilidades.StringToColor(textoCor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JColorChooser jcc = new JColorChooser();
        jcc.addChooserPanel(new PainelSelecaoCor(modelo));
        jcc.setColor(c);
        JDialog dialog = JColorChooser.createDialog(form, Editor.fromConfiguracao.getValor("Controler.MSG_CHOOSE_COLLOR"), true, jcc, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                c = jcc.getColor();
            }
        }, null);
        dialog.setVisible(true);
        return c == null ? textoCor : Utilidades.ColorToString(c);
    }

    public static String ShowDlgCor(JComponent form, String textoCor) {
        c = Color.BLACK;
        try {
            c = Utilidades.StringToColor(textoCor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        c = JColorChooser.showDialog(form, Editor.fromConfiguracao.getValor("Controler.MSG_CHOOSE_COLLOR"), c);
        return c == null ? textoCor : Utilidades.ColorToString(c);
    }

    public static String ShowDlgInputText(JComponent form, String textoCor) {
        String res = JOptionPane.showInputDialog(form, Editor.fromConfiguracao.getValor("Controler.MSG_INPUT_TEXT_LABEL"), textoCor);
        return res == null ? "" : res;
    }

    public static String ShowDlgFileImg(JComponent form) {
        JFileChooser f = new JFileChooser();
        int returnVal = f.showDialog(form, Editor.fromConfiguracao.getValor("Controler.dlg.image"));
        f.setFileSelectionMode(0);
        if (returnVal == 0) {
            File file = f.getSelectedFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    public static File ShowDlgSaveDiagrama(JComponent form, Diagrama diag) {
        int returnVal;
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("BrModelo(bin)", "brM3");
        FileNameExtensionFilter filter2 = new FileNameExtensionFilter("BrModelo(xml)", "xml");
        f.addChoosableFileFilter(filter);
        f.addChoosableFileFilter(filter2);
        f.setAcceptAllFileFilterUsed(false);
        f.setFileFilter(filter);
        if (dir.isEmpty()) {
            dir = System.getProperty("user.dir");
        }
        f.setCurrentDirectory(new File(dir + "."));
        f.setDialogTitle(Editor.fromConfiguracao.getValor("Controler.MSG_SAVE_TITLE") + " " + diag.getNomeFormatado());
        if (!diag.getNome().isEmpty()) {
            f.setSelectedFile(new File(diag.getNome()));
        }
        if ((returnVal = f.showSaveDialog(form)) == 0) {
            File file = f.getSelectedFile();
            String ext = Arquivo.getExtension(file);
            if (ext == null) {
                ext = "";
            }
            String arq = file.getAbsolutePath();
            dir = f.getCurrentDirectory().getAbsolutePath();
            if (f.getFileFilter().equals(filter) && !"brM3".toUpperCase().equals(ext.toUpperCase())) {
                return new File(arq + "." + "brM3");
            }
            if (f.getFileFilter().equals(filter2) && !"xml".toUpperCase().equals(ext.toUpperCase())) {
                return new File(arq + "." + "xml");
            }
            return file;
        }
        return null;
    }

    public static File ShowDlgSaveAsImg(JComponent form, Diagrama diag) {
        int returnVal;
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Imagem (png)", "png");
        FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Imagem (bmp)", "bmp");
        f.addChoosableFileFilter(filter);
        f.addChoosableFileFilter(filter2);
        f.setAcceptAllFileFilterUsed(false);
        f.setFileFilter(filter);
        if (dir.isEmpty()) {
            dir = System.getProperty("user.dir");
        }
        f.setCurrentDirectory(new File(dir));
        f.setDialogTitle(Editor.fromConfiguracao.getValor("Controler.MSG_EPRT_TITLE"));
        if (!diag.getNome().isEmpty()) {
            f.setSelectedFile(new File(diag.getNome()));
        }
        if ((returnVal = f.showSaveDialog(form)) == 0) {
            File file = f.getSelectedFile();
            String ext = Arquivo.getExtension(file);
            if (ext == null) {
                ext = "";
            }
            dir = file.getAbsolutePath();
            if (f.getFileFilter().equals(filter) && !"png".toUpperCase().equals(ext.toUpperCase())) {
                return new File(file.getAbsolutePath() + "." + "png");
            }
            if (f.getFileFilter().equals(filter2) && !"bmp".toUpperCase().equals(ext.toUpperCase())) {
                return new File(file.getAbsolutePath() + "." + "bmp");
            }
            return file;
        }
        return null;
    }

    public static File ShowDlgSaveAsAny(JComponent form, String ar) {
        int returnVal;
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setAcceptAllFileFilterUsed(true);
        if (dir.isEmpty()) {
            dir = System.getProperty("user.dir");
        }
        f.setCurrentDirectory(new File(dir));
        f.setDialogTitle(Editor.fromConfiguracao.getValor("Controler.MSG_EPRT_TITLE"));
        if (!ar.isEmpty()) {
            f.setSelectedFile(new File(ar));
        }
        if ((returnVal = f.showSaveDialog(form)) == 0) {
            File file = f.getSelectedFile();
            dir = file.getAbsolutePath();
            return file;
        }
        return null;
    }

    public static File ShowDlgLoadDiagrama(String preDir, Editor master) {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("BrModelo", "brM3", "xml"));
        f.addChoosableFileFilter(new FileNameExtensionFilter("BrModelo(bin)", "brM3"));
        f.addChoosableFileFilter(new FileNameExtensionFilter("BrModelo(xml)", "xml"));
        f.setAcceptAllFileFilterUsed(true);
        if (preDir == null || "".equals(preDir)) {
            f.setCurrentDirectory(new File(System.getProperty("user.dir")));
        } else {
            File f2 = new File(preDir);
            if (f2.isDirectory()) {
                f.setCurrentDirectory(f2);
            } else {
                f.setCurrentDirectory(new File(f2.getPath()));
            }
        }
        int returnVal = f.showOpenDialog((Component)((Object)master.getFramePrincipal()));
        if (returnVal == 0) {
            File file = f.getSelectedFile();
            if (!file.exists()) {
                return null;
            }
            return file;
        }
        return null;
    }

    public static Font ShowDlgFont(JComponent form, Font selected) {
        JFontChooser fc = JFC;
        fc.setSelectedFont(selected);
        if (fc.showDialog(form) == 0) {
            fc.makeLastRegistred();
            return fc.getSelectedFont();
        }
        return null;
    }
}

