/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class DesenhadorDeTexto
implements Serializable {
    private static final long serialVersionUID = -1504310755614588296L;
    private boolean CentrarTextoHorizontal = false;
    private boolean CentrarTextoVertical = false;
    private boolean AlinharEsquerda = true;
    private boolean AlinharDireita = false;
    public Point CorretorPosicao = new Point(0, 0);
    private String Texto = "";
    private String[] Textos;
    private transient LineBreakMeasurer[] lbmTexto;
    private Font font;
    public boolean LimitarAreaDePintura = true;
    private int MaxWidth = 0;
    private int MaxHeigth = 0;

    public DesenhadorDeTexto() {
    }

    public DesenhadorDeTexto(String texto, Font font, boolean centraTexto) {
        this.setTexto(texto);
        this.font = font;
        this.CentrarTextoVertical = centraTexto;
        this.setCentrarTextoHorizontal(centraTexto);
    }

    public boolean isCentrarTextoHorizontal() {
        return this.CentrarTextoHorizontal;
    }

    public void setCentrarTextoHorizontal(boolean CentrarTextoHorizontal) {
        this.CentrarTextoHorizontal = CentrarTextoHorizontal;
        if (CentrarTextoHorizontal) {
            this.AlinharEsquerda = false;
            this.AlinharDireita = false;
        }
    }

    public boolean isCentrarTextoVertical() {
        return this.CentrarTextoVertical;
    }

    public void setCentrarTextoVertical(boolean CentrarTexto) {
        this.CentrarTextoVertical = CentrarTexto;
    }

    public boolean isAlinharEsquerda() {
        return this.AlinharEsquerda;
    }

    public void setAlinharEsquerda(boolean AlinharEsquerda) {
        this.AlinharEsquerda = AlinharEsquerda;
        if (AlinharEsquerda) {
            this.CentrarTextoHorizontal = false;
            this.AlinharDireita = false;
        }
    }

    public boolean isAlinharDireita() {
        return this.AlinharDireita;
    }

    public void setAlinharDireita(boolean AlinharDireita) {
        this.AlinharDireita = AlinharDireita;
        if (AlinharDireita) {
            this.AlinharEsquerda = false;
            this.CentrarTextoHorizontal = false;
        }
    }

    public String getTexto() {
        return this.Texto;
    }

    public void setTexto(String Texto2) {
        this.Texto = Texto2;
        if (Texto2 == null || Texto2.equals("")) {
            return;
        }
        this.Textos = Texto2.split("\n");
        this.lbmTexto = null;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.lbmTexto = null;
    }

    public int getMaxWidth() {
        return this.MaxWidth;
    }

    public int getMaxHeigth() {
        return this.MaxHeigth;
    }

    public void PinteTexto(Graphics2D g, Color foreColor, Rectangle clientArea, String texto) {
        if (!this.Texto.equals(texto)) {
            this.setTexto(texto);
        }
        if (this.Texto.equals("") || this.Texto == null) {
            return;
        }
        g.setPaint(foreColor);
        LineBreakMeasurer[] lbms = this.getLineBreakMeasurers(g);
        if (lbms == null || lbms.length == 0) {
            return;
        }
        Rectangle bkp = g.getClipBounds();
        if (this.LimitarAreaDePintura) {
            g.clipRect(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        }
        int recuo = 2;
        int x = clientArea.x + recuo + this.CorretorPosicao.x;
        int y = clientArea.y + this.CorretorPosicao.y;
        int w = clientArea.width - 2 * recuo - this.CorretorPosicao.x;
        int h = clientArea.height - this.CorretorPosicao.y;
        float wrappingWidth = w;
        this.MaxHeigth = 0;
        this.MaxWidth = 0;
        if (this.isCentrarTextoVertical()) {
            int esp = 0;
            float corr = 0.0f;
            for (int i = 0; i < lbms.length; ++i) {
                LineBreakMeasurer lbm = lbms[i];
                lbm.setPosition(0);
                while (lbm.getPosition() < this.Textos[i].length()) {
                    TextLayout layout;
                    try {
                        layout = lbm.nextLayout(wrappingWidth);
                    }
                    catch (Exception e) {
                        if (this.LimitarAreaDePintura) {
                            g.setClip(bkp);
                        }
                        return;
                    }
                    corr = layout.getDescent() + layout.getLeading();
                    esp = (int)((float)esp + (layout.getAscent() + corr));
                }
            }
            esp = (int)((float)esp - corr);
            y = (h - esp) / 2 + y;
        }
        for (int i = 0; i < lbms.length; ++i) {
            LineBreakMeasurer lbm = lbms[i];
            lbm.setPosition(0);
            while (lbm.getPosition() < this.Textos[i].length()) {
                TextLayout layout;
                try {
                    layout = lbm.nextLayout(wrappingWidth);
                }
                catch (Exception e) {
                    if (this.LimitarAreaDePintura) {
                        g.setClip(bkp);
                    }
                    return;
                }
                y = (int)((float)y + layout.getAscent());
                int le = x;
                int larg = (int)layout.getBounds().getWidth();
                if (this.isCentrarTextoHorizontal()) {
                    le = x + (w - larg) / 2;
                } else if (this.isAlinharDireita()) {
                    le = x + w - larg;
                }
                layout.draw(g, le, y);
                this.MaxHeigth = y;
                y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
                this.MaxWidth = Math.max(this.MaxWidth, larg);
            }
        }
        this.MaxHeigth -= clientArea.y;
        if (this.LimitarAreaDePintura) {
            g.setClip(bkp);
        }
    }

    public void PinteTexto(Graphics2D g, Rectangle clientArea, String texto) {
        Font bkpf = g.getFont();
        g.setFont(this.getFont());
        if (!this.Texto.equals(texto)) {
            this.setTexto(texto);
        }
        if (this.Texto.equals("") || this.Texto == null) {
            return;
        }
        LineBreakMeasurer[] lbms = this.getLineBreakMeasurers(g);
        if (lbms == null || lbms.length == 0) {
            return;
        }
        Rectangle bkp = g.getClipBounds();
        if (this.LimitarAreaDePintura) {
            g.clipRect(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        }
        int recuo = 2;
        int x = clientArea.x + recuo + this.CorretorPosicao.x;
        int y = clientArea.y + this.CorretorPosicao.y;
        int w = clientArea.width - 2 * recuo - this.CorretorPosicao.x;
        int h = clientArea.height - this.CorretorPosicao.y;
        float wrappingWidth = w;
        this.MaxHeigth = 0;
        this.MaxWidth = 0;
        if (this.isCentrarTextoVertical()) {
            int esp = 0;
            float corr = 0.0f;
            for (int i = 0; i < lbms.length; ++i) {
                LineBreakMeasurer lbm = lbms[i];
                lbm.setPosition(0);
                while (lbm.getPosition() < this.Textos[i].length()) {
                    TextLayout layout;
                    try {
                        layout = lbm.nextLayout(wrappingWidth);
                    }
                    catch (Exception e) {
                        if (this.LimitarAreaDePintura) {
                            g.setClip(bkp);
                        }
                        return;
                    }
                    corr = layout.getDescent() + layout.getLeading();
                    esp = (int)((float)esp + (layout.getAscent() + corr));
                }
            }
            esp = (int)((float)esp - corr);
            y = (h - esp) / 2 + y;
        }
        for (int i = 0; i < lbms.length; ++i) {
            LineBreakMeasurer lbm = lbms[i];
            lbm.setPosition(0);
            while (lbm.getPosition() < this.Textos[i].length()) {
                TextLayout layout;
                try {
                    layout = lbm.nextLayout(wrappingWidth);
                }
                catch (Exception e) {
                    if (this.LimitarAreaDePintura) {
                        g.setClip(bkp);
                    }
                    return;
                }
                y = (int)((float)y + layout.getAscent());
                int le = x;
                int larg = (int)layout.getBounds().getWidth();
                if (this.isCentrarTextoHorizontal()) {
                    le = x + (w - larg) / 2;
                } else if (this.isAlinharDireita()) {
                    le = x + w - larg;
                }
                layout.draw(g, le, y);
                this.MaxHeigth = y;
                y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
                this.MaxWidth = Math.max(this.MaxWidth, larg);
            }
        }
        this.MaxHeigth -= clientArea.y;
        if (this.LimitarAreaDePintura) {
            g.setClip(bkp);
        }
        g.setFont(bkpf);
    }

    private LineBreakMeasurer[] getLineBreakMeasurers(Graphics2D g) {
        if (this.lbmTexto == null && this.Texto != null && !this.Texto.equals("")) {
            this.lbmTexto = new LineBreakMeasurer[this.Textos.length];
            for (int i = 0; i < this.lbmTexto.length; ++i) {
                String tmp = this.Textos[i].isEmpty() ? " " : this.Textos[i];
                AttributedString attribString = new AttributedString(tmp);
                attribString.addAttribute(TextAttribute.FONT, this.getFont());
                AttributedCharacterIterator attribCharIterator = attribString.getIterator();
                FontRenderContext frc = g.getFontRenderContext();
                this.lbmTexto[i] = new LineBreakMeasurer(attribCharIterator, frc);
            }
        }
        return this.lbmTexto;
    }
}

