/*
 * Decompiled with CFR 0.152.
 */
package principal.cli;

import controlador.Editor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Sintaxe {
    private String comando;
    public final ArrayList<Sintaxe> Proximos = new ArrayList();
    public static final String VariavelNum = "variavelnum";
    public static final String Variavel = "variavel";
    private String cmdDigitado = null;
    public String varValor = "";

    public static Sintaxe Create(String fstSintaxe) {
        return new Sintaxe(fstSintaxe);
    }

    public Sintaxe(String com) {
        this.comando = com;
    }

    public String getComando() {
        return this.comando;
    }

    public void setComando(String comando) {
        this.comando = comando;
    }

    public void AddProx(String[] prox) {
        ArrayList<String> px = new ArrayList<String>();
        px.addAll(Arrays.asList(prox));
        this.AddProx(px);
    }

    public void AddProx(ArrayList<String> prox) {
        prox.stream().forEach(str -> this.Proximos.add(new Sintaxe((String)str)));
    }

    public Sintaxe AddProx(String prox) {
        Sintaxe tmp = new Sintaxe(prox);
        this.Proximos.add(tmp);
        return tmp;
    }

    public void AddProx(String[][] proxx) {
        for (String[] prox : proxx) {
            boolean pri = true;
            Sintaxe fst = null;
            for (String str : prox) {
                if (pri) {
                    pri = false;
                    fst = new Sintaxe(str);
                    this.Proximos.add(fst);
                    continue;
                }
                fst.Proximos.add(new Sintaxe(str));
            }
        }
    }

    public void Listar(StringBuilder lst, String tabs) {
        String tab = tabs + " - " + this.getSintaxeCMD();
        if (this.Proximos.isEmpty()) {
            lst.append(tab);
            lst.append("\n");
        }
        for (Sintaxe sx : this.Proximos) {
            sx.Listar(lst, tab);
        }
    }

    public Sintaxe FindByCMD(String com) {
        for (Sintaxe sx : this.Proximos) {
            if (!sx.getComando().equals(com)) continue;
            return sx;
        }
        return this;
    }

    boolean isValido(ArrayList<Sintaxe> cadeia, ArrayList<String> comm) {
        return this.isValido(cadeia, comm, 0);
    }

    private boolean isCMDTipoVariavel() {
        return this.getComando().equals(Variavel) || this.getComando().equals(VariavelNum);
    }

    boolean isValido(ArrayList<Sintaxe> cadeia, ArrayList<String> comm, int nv) {
        if (nv > comm.size() - 1) {
            return false;
        }
        if (this.isCMD(comm.get(nv))) {
            cadeia.add(this);
            if (++nv == comm.size() && this.Proximos.isEmpty()) {
                return true;
            }
            for (Sintaxe sx : this.Proximos) {
                if (!sx.isValido(cadeia, comm, nv)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSintaxe(ArrayList<String> comm) {
        String res = this.getBestCMD(comm.get(0));
        if (res.isEmpty()) {
            return "Comando Inexistente";
        }
        if (this.Proximos.isEmpty()) {
            return res;
        }
        Sintaxe prx = null;
        int nv = 0;
        for (Sintaxe sx : this.Proximos) {
            int tmp = sx.getNivelDeValidade(comm, 1);
            if (tmp <= nv) continue;
            nv = tmp;
            prx = sx;
        }
        if (prx == null || comm.size() == 1) {
            res = res + " [";
            for (Sintaxe sx : this.Proximos) {
                res = res + sx.getSintaxeCMD() + ",";
            }
            res = res.substring(0, res.length() - 1) + "]";
            return res;
        }
        return prx.getSintaxe(res, comm, 1);
    }

    public String getSintaxe(String stx, ArrayList<String> comm, int nv) {
        if (nv > comm.size() - 1) {
            return stx;
        }
        String res = this.getBestCMD(comm.get(nv));
        res = stx = stx + " " + res;
        if (this.Proximos.isEmpty()) {
            return stx;
        }
        int tmpnv = ++nv;
        Sintaxe prx = null;
        for (Sintaxe sx : this.Proximos) {
            int tmp = sx.getNivelDeValidade(comm, nv);
            if (tmp <= tmpnv) continue;
            tmpnv = tmp;
            prx = sx;
        }
        if (prx == null || comm.size() == nv) {
            res = res + " [";
            for (Sintaxe sx : this.Proximos) {
                res = res + sx.getSintaxeCMD() + ",";
            }
            res = res.substring(0, res.length() - 1) + "]";
            return res;
        }
        return prx.getSintaxe(res, comm, nv);
    }

    public String AutoComplete(ArrayList<String> comm) {
        String res = this.AutoComplete(comm, 0);
        return res;
    }

    public String AutoComplete(ArrayList<String> comm, int nv) {
        if (nv > comm.size() - 1) {
            return "";
        }
        String tmp = comm.get(nv);
        String res = this.getBestCMD(tmp);
        if (res.isEmpty()) {
            return tmp;
        }
        if (this.isCMDTipoVariavel()) {
            res = tmp;
        }
        if (++nv == comm.size()) {
            if (this.Proximos.isEmpty()) {
                return res;
            }
            return res + " ";
        }
        int tmpnv = nv;
        Sintaxe prx = null;
        for (Sintaxe sx : this.Proximos) {
            int idx = sx.getNivelDeValidade(comm, nv);
            if (idx <= tmpnv) continue;
            tmpnv = idx;
            prx = sx;
        }
        if (prx == null) {
            return res + " " + comm.get(nv);
        }
        return res + " " + prx.AutoComplete(comm, nv);
    }

    public int getNivelDeValidade(ArrayList<String> comm) {
        return this.getNivelDeValidade(comm, 0);
    }

    public int getNivelDeValidade(ArrayList<String> comm, int nv) {
        if (nv > comm.size() - 1) {
            return nv--;
        }
        if (this.isCMD(comm.get(nv))) {
            int subnv = nv + 1;
            if (subnv == comm.size() && this.Proximos.isEmpty()) {
                return subnv;
            }
            int res = nv;
            for (Sintaxe sx : this.Proximos) {
                res = Math.max(res, sx.getNivelDeValidade(comm, subnv));
            }
            return res;
        }
        return nv--;
    }

    public void Preencha(ArrayList<String> comm, HashMap<String, String> Vars) {
        this.Preencha(comm, Vars, 0);
    }

    public void Preencha(ArrayList<String> comm, HashMap<String, String> Vars, int nv) {
        if (nv == comm.size()) {
            return;
        }
        if (this.isCMD(comm.get(nv))) {
            this.cmdDigitado = comm.get(nv);
            if (this.isCMDTipoVariavel()) {
                this.varValor = Vars.get(this.cmdDigitado);
            }
            ++nv;
            for (Sintaxe sx : this.Proximos) {
                sx.Preencha(comm, Vars, nv);
            }
        }
    }

    String getStrPreenchida() {
        return "N\u00e3o sei o que eu quiz Not supported yet.";
    }

    public boolean isCMD(String incmd) {
        String[] cmds = this.getStrSintaxe(this.getComando()).split("\\|");
        if (this.isCMDTipoVariavel()) {
            return incmd.startsWith(cmds[1]);
        }
        incmd = incmd.toUpperCase();
        for (String str : cmds) {
            if (!str.equals(incmd)) continue;
            return true;
        }
        return false;
    }

    public String getBestCMD(String incmd) {
        return this.isCMD(incmd) ? this.getStrSintaxe(this.getComando()).split("\\|")[0] : "";
    }

    public String getSintaxeCMD() {
        return this.getStrSintaxe(this.getComando()).split("\\|")[0];
    }

    public String getStrSintaxe(String partCap) {
        return Editor.fromConfiguracao.getValor("Controler.cli.exp." + partCap.toLowerCase());
    }
}

