/*
 * Decompiled with CFR 0.152.
 */
package partepronta;

import controlador.Diagrama;
import desenho.FormaElementar;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import partepronta.GerenciadorSubParte;
import util.BrLogger;
import util.ImageGenerate;
import util.TratadorDeImagens;

public class GerenciadorPartes
implements Serializable {
    private static final long serialVersionUID = 5549339395194123920L;
    private final ArrayList<GerenciadorSubParte> lista = new ArrayList();
    private boolean mudou = false;

    public ArrayList<GerenciadorSubParte> getLista() {
        return this.lista;
    }

    public void Add(GerenciadorSubParte parte) {
        this.lista.add(parte);
        this.setMudou(true);
    }

    public GerenciadorSubParte Add(String texto, Diagrama diag) {
        byte[] byteImage = this.ImagemDaSelecao(diag);
        String XMLCopiado = Diagrama.SaveToXml(diag, true);
        String versaoDiagrama = diag.getVersao();
        Diagrama.TipoDeDiagrama tipo = diag.getTipo();
        GerenciadorSubParte parte = new GerenciadorSubParte(texto, byteImage, XMLCopiado, versaoDiagrama, tipo);
        this.Add(parte);
        return parte;
    }

    public byte[] ImagemDaSelecao(Diagrama diagramaAtual) {
        int borda = 2;
        Point p2 = diagramaAtual.getPontoExtremoSelecionado();
        int minX = p2.x;
        int minY = p2.y;
        for (int i = diagramaAtual.getItensSelecionados().size() - 1; i > -1; --i) {
            FormaElementar el = diagramaAtual.getItensSelecionados().get(i);
            minX = Math.min(minX, el.getLeft());
            minY = Math.min(minY, el.getTop());
        }
        minX = Math.max(minX - 2, 0);
        minY = Math.max(minY - 2, 0);
        BufferedImage cp_img = ImageGenerate.geraImagemForPrnSelecao(diagramaAtual, p2.x + 2, p2.y + 2);
        return TratadorDeImagens.toByteArray(cp_img.getSubimage(minX, minY, p2.x - minX, p2.y - minY));
    }

    public void Remova(GerenciadorSubParte sp) {
        this.lista.remove(sp);
        this.setMudou(true);
    }

    public boolean isMudou() {
        return this.mudou;
    }

    public void setMudou(boolean mudou) {
        this.mudou = mudou;
    }

    public static GerenciadorPartes LoadData(String arq) {
        try {
            GerenciadorPartes res;
            FileInputStream fi = new FileInputStream(arq);
            try (ObjectInputStream in = new ObjectInputStream(fi);){
                res = (GerenciadorPartes)in.readObject();
                in.close();
            }
            res.setMudou(false);
            return res;
        }
        catch (IOException | ClassNotFoundException | NullPointerException iOException) {
            BrLogger.Logger("ERROR_TEMPLATE_LOAD", iOException.getMessage());
            return null;
        }
    }

    public static GerenciadorPartes LoadDataTemplate() {
        String tmp = System.getProperty("user.dir") + File.separator + "Template.brMt";
        GerenciadorPartes gp = GerenciadorPartes.LoadData(tmp);
        if (gp == null) {
            gp = new GerenciadorPartes();
            GerenciadorPartes.SaveDataTemplate(gp);
        }
        return gp;
    }

    public static boolean SaveData(GerenciadorPartes obj, String fileName) {
        try {
            FileOutputStream fo = new FileOutputStream(fileName);
            try (ObjectOutputStream out = new ObjectOutputStream(fo);){
                out.writeObject(obj);
            }
            obj.setMudou(false);
            return true;
        }
        catch (IOException iOException) {
            BrLogger.Logger("ERROR_TEMPLATE_SAVELOAD", iOException.getMessage());
            return false;
        }
    }

    public static boolean SaveDataTemplate(GerenciadorPartes obj) {
        String tmp = System.getProperty("user.dir") + File.separator + "Template.brMt";
        return GerenciadorPartes.SaveData(obj, tmp);
    }

    public void Edit(GerenciadorSubParte Parte, String txt) {
        Parte.setTitulo(txt);
        this.setMudou(true);
    }
}

