/*
 * Decompiled with CFR 0.152.
 */
package diagramas.eap;

import desenho.FormaElementar;
import desenho.formas.Forma;
import diagramas.eap.EapBarraLigacao;
import diagramas.eap.EapLigacao;
import diagramas.eap.EapProcesso;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Objects;
import principal.cli.CliDiagramaProcessador;
import principal.cli.MasterCli;
import principal.cli.Sintaxe;
import principal.cli.Variavel;

public class EapCLI
extends CliDiagramaProcessador {
    final String cmdNOVO = "novo";
    final String cmdEAP = "eap.eap";
    final String cmdPROCESSO = "eap.processo";
    final String cmdHORIZONTAL = "horizontal";
    final String cmdVERTICAL = "vertical";
    final String cmdCENTRO = "centro";
    final String cmdESQUERDA = "esquerda";
    final String cmdDIREITA = "direita";
    final int VERTICAL = 0;
    final int HORIZONTAL = 1;
    final int ABAIXO = 0;
    final int ESQUERDA = 1;
    final int ACIMA = 2;
    int X = 0;
    int Y = 0;

    public EapCLI(MasterCli cli) {
        super(cli);
        Sintaxe cmdnovo = new Sintaxe("novo");
        this.Comandos.add(cmdnovo);
        cmdnovo.AddProx(new String[][]{{"eap.eap", "horizontal", "vertical"}, {"eap.processo", "variavelnum"}});
        cmdnovo.FindByCMD("eap.processo").FindByCMD("variavelnum").AddProx("variavel");
        cmdnovo.FindByCMD("eap.eap").FindByCMD("horizontal").AddProx(new String[][]{{"centro", "variavel"}, {"esquerda", "variavel"}, {"direita", "variavel"}});
        cmdnovo.FindByCMD("eap.eap").FindByCMD("vertical").AddProx(new String[]{"variavel"});
    }

    @Override
    public boolean ProcesseComandoValido(ArrayList<Sintaxe> cadeia, ArrayList<String> comm) {
        if (super.ProcesseComandoValido(cadeia, comm)) {
            return true;
        }
        this.CLI.doShowMsg(comm.toString());
        Sintaxe sx = cadeia.get(0);
        if (sx.getComando().equals("novo")) {
            String cmd;
            sx = cadeia.get(1);
            switch (cmd = sx.getComando()) {
                case "eap.processo": {
                    this.getDiag().isCarregando = true;
                    boolean r = this.processecmdNovoProcesso(comm.get(2), comm.get(3));
                    this.getDiag().isCarregando = false;
                    if (r) {
                        this.getDiag().DoMuda(null);
                        this.getDiag().repaint();
                    }
                    return r;
                }
                case "eap.eap": {
                    this.getDiag().isCarregando = true;
                    boolean r2 = this.processecmdNovoEap(cadeia, comm);
                    this.getDiag().isCarregando = false;
                    if (r2) {
                        this.getDiag().DoMuda(null);
                        this.getDiag().repaint();
                    }
                    return r2;
                }
            }
        }
        return true;
    }

    private boolean processecmdNovoProcesso(String var1, String var2) {
        Point p = this.restoreVarToPoint(var1);
        if (p.x == -1) {
            this.setLastCmdErro(true);
            this.setErroMsg("Erro ao informar o valor da posi\u00e7\u00e3o do objeto");
            return false;
        }
        this.NovoProcesso(p, ((Variavel)this.Vars.get(var2)).getValor());
        return true;
    }

    private EapProcesso NovoProcesso(Point posi, String txt) {
        FormaElementar fnd = this.GetByID(txt);
        if (fnd instanceof EapProcesso) {
            return (EapProcesso)fnd;
        }
        if (this.IsCommandGetID(txt)) {
            txt = "N\u00e3o encontrado!";
        }
        int larg = this.getAmbientInteger("amb.obj.w");
        int alt = this.getAmbientInteger("amb.obj.h");
        EapProcesso eapp = new EapProcesso(this.getDiag(), EapProcesso.class.getSimpleName());
        eapp.SetBounds(posi.x, posi.y, larg, alt);
        eapp.SetTexto(txt);
        eapp.reSetBounds();
        eapp.Reposicione();
        eapp.BringToFront();
        return eapp;
    }

    private EapBarraLigacao NovaBarra(Point posi, int dir) {
        EapBarraLigacao eapp = new EapBarraLigacao(this.getDiag(), EapBarraLigacao.class.getSimpleName());
        eapp.setDirecao(dir);
        eapp.setLocation(posi);
        eapp.reSetBounds();
        eapp.Reposicione();
        eapp.BringToFront();
        return eapp;
    }

    private boolean processecmdNovoEap(ArrayList<Sintaxe> cadeia, ArrayList<String> comm) {
        String strs;
        Sintaxe sx = cadeia.get(2);
        String cmd = sx.getComando();
        if (cmd.equals("vertical")) {
            strs = comm.get(3);
        } else {
            strs = comm.get(4);
            cmd = cmd + cadeia.get(3).getComando();
        }
        ArrayList<String> itens = this.processeStr(strs);
        if (itens.size() < 2) {
            this.setLastCmdErro(true);
            this.setErroMsg("Erro ao informar a quantidade de processos.");
            return false;
        }
        this.X = this.getAmbientInteger("amb.scr.x");
        this.Y = this.getAmbientInteger("amb.scr.y");
        EapProcesso proc = this.criarUnidades(itens, cmd, true);
        EapBarraLigacao b = proc.getListaDeFormasLigadas().stream().filter(f -> f instanceof EapBarraLigacao).map(f -> (EapBarraLigacao)f).findFirst().orElse(null);
        if (b != null) {
            b.getMaster().isCarregando = true;
            b.FullOrganizeEap();
            b.getMaster().isCarregando = false;
        }
        return true;
    }

    private ArrayList<String> processeStr(String strs) {
        strs = ((Variavel)this.Vars.get(strs)).getValor();
        strs = this.removaConteiner(strs, this.Vars);
        String[] objs = strs.split("\n");
        ArrayList<String> itens = new ArrayList<String>();
        for (String str : objs) {
            if (str == null || str.isEmpty()) continue;
            itens.add(str);
        }
        return itens;
    }

    public boolean haveVars(String cmd) {
        String[] vls;
        for (String a : vls = cmd.split(" ")) {
            if (!a.startsWith("$$") || !this.Vars.containsKey(a)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> reempilhe(String cmd) {
        String[] vls = cmd.split(" ");
        ArrayList<String> res = new ArrayList<String>();
        for (String a : vls) {
            if (!a.startsWith("$$var_") || !this.Vars.containsKey(a)) continue;
            res.addAll(this.processeStr(a));
        }
        int i = cmd.indexOf("$$var_");
        if (i > 0) {
            res.add(0, cmd.substring(0, i));
        } else {
            res.add(0, "?");
        }
        return res;
    }

    private EapProcesso criarUnidades(ArrayList<String> itens, String tp, boolean principal) {
        EapProcesso p;
        ArrayList<String> subs;
        String tmp;
        int i;
        EapBarraLigacao br = null;
        EapProcesso PP = null;
        if (tp.equals("vertical")) {
            PP = this.NovoProcesso(new Point(this.X, this.Y), itens.get(0));
            this.Y = PP.getTopHeight() + 50;
            br = this.NovaBarra(new Point(this.X + PP.getWidth() / 2 - 5, this.Y), 0);
            this.Y += 50;
            this.Ligue(br, PP, 0);
            this.X += 100;
            for (int i2 = 1; i2 < itens.size(); ++i2) {
                EapProcesso p2;
                String tmp2 = itens.get(i2);
                if (this.haveVars(tmp2)) {
                    ArrayList<String> subs2 = this.reempilhe(tmp2);
                    p2 = this.criarUnidades(subs2, tp, false);
                    this.X -= 100;
                } else {
                    p2 = this.NovoProcesso(new Point(this.X, this.Y), tmp2);
                }
                this.Y = p2.getTopHeight() + 50;
                this.Ligue(br, p2, 1);
            }
        }
        int larg = this.getAmbientInteger("amb.obj.w");
        int x = this.X;
        int y = this.Y;
        if (tp.equals("horizontalcentro")) {
            int bkp = x;
            x = x + ((itens.size() - 1) * (larg + 10) - 10) / 2 - larg / 2;
            PP = this.NovoProcesso(new Point(x, y), itens.get(0));
            y = PP.getTopHeight() + 50;
            x = PP.getLeft();
            br = this.NovaBarra(new Point(x, y), 1);
            Objects.requireNonNull(br);
            br.setPosicaoDireto(0);
            y += 50;
            this.Ligue(br, PP, 0);
            x = bkp;
            for (i = 1; i < itens.size(); ++i) {
                tmp = itens.get(i);
                if (this.haveVars(tmp)) {
                    this.X = x;
                    this.Y = y;
                    subs = this.reempilhe(tmp);
                    p = this.criarUnidades(subs, tp, false);
                } else {
                    p = this.NovoProcesso(new Point(x, y), tmp);
                }
                x += 130;
                this.Ligue(br, p, 2);
            }
        }
        if (tp.equals("horizontalesquerda")) {
            int tmp2 = (itens.size() - 1) * (larg + 10);
            PP = this.NovoProcesso(new Point(x += tmp2, y), itens.get(0));
            y = PP.getTopHeight() + 50;
            br = this.NovaBarra(new Point(x -= tmp2, y), 1);
            Objects.requireNonNull(br);
            br.setPosicaoDireto(1);
            y += 50;
            this.Ligue(br, PP, 0);
            for (i = 1; i < itens.size(); ++i) {
                tmp = itens.get(i);
                if (this.haveVars(tmp)) {
                    this.X = x;
                    this.Y = y;
                    subs = this.reempilhe(tmp);
                    p = this.criarUnidades(subs, tp, false);
                } else {
                    p = this.NovoProcesso(new Point(x, y), tmp);
                }
                x += 130;
                this.Ligue(br, p, 2);
            }
        }
        if (tp.equals("horizontaldireita")) {
            PP = this.NovoProcesso(new Point(x, y), itens.get(0));
            x = PP.getLeft();
            x = x + (larg + 10) + 10;
            y = PP.getTopHeight() + 50;
            br = this.NovaBarra(new Point(x, y), 1);
            br.setPosicaoDireto(br.HDIREITA);
            y += 50;
            this.Ligue(br, PP, 0);
            for (int i3 = 1; i3 < itens.size(); ++i3) {
                EapProcesso p3;
                String tmp3 = itens.get(i3);
                if (this.haveVars(tmp3)) {
                    this.X = x;
                    this.Y = y;
                    ArrayList<String> subs3 = this.reempilhe(tmp3);
                    p3 = this.criarUnidades(subs3, tp, false);
                } else {
                    p3 = this.NovoProcesso(new Point(x, y), tmp3);
                }
                x += larg + 10;
                this.Ligue(br, p3, 2);
            }
        }
        if (br != null && principal) {
            br.PreOrganizeEap();
        }
        return PP;
    }

    private void Ligue(EapBarraLigacao br, EapProcesso p, int tp) {
        Point pt2;
        Point pt1;
        EapLigacao linha = new EapLigacao(this.getDiag());
        switch (tp) {
            case 0: {
                pt1 = new Point(p.getLeft() + p.getWidth() / 2, p.getTopHeight() - 2);
                pt2 = new Point(br.getLeft() + br.getWidth() / 2, br.getTop() + 2);
                break;
            }
            case 1: {
                pt1 = new Point(p.getLeft() + 2, p.getTop() + p.getHeight() / 2);
                pt2 = new Point(br.getLeft() + br.getWidth() / 2, br.getTopHeight() - 2);
                break;
            }
            default: {
                pt1 = new Point(p.getLeft() + p.getWidth() / 2, p.getTop() + 2);
                pt2 = new Point(br.getLeft() + br.getWidth() / 2, br.getTopHeight() - 2);
            }
        }
        linha.FormasALigar = new Forma[]{br, p};
        linha.Inicie(new Rectangle(pt2.x, pt2.y, pt1.x - pt2.x, pt1.y - pt2.y));
    }
}

