/*
 * Decompiled with CFR 0.152.
 */
package diagramas.conceitual;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.FormaNaoRetangularBase;
import desenho.linhas.PontoDeLinha;
import desenho.preAnyDiagrama.PreAtributo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.BrLogger;
import util.XMLGenerate;

public class Atributo
extends PreAtributo {
    private static final long serialVersionUID = -5223581706365131753L;
    private int cardMaxima = -1;
    private boolean multivalorado = false;
    private String tipoAtributo = "";
    private int cardMinima = 1;
    public final int CONST_DO_ORGATTR = 123;

    public Atributo(Diagrama modelo) {
        super(modelo);
        this.nodic = false;
    }

    public Atributo(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.nodic = false;
    }

    @Override
    public ArrayList<Integer> getAncorasCode() {
        ArrayList<Integer> res = super.getAncorasCode();
        Integer[] ancorasCode = new Integer[]{2};
        res.addAll(Arrays.asList(ancorasCode));
        return res;
    }

    public void setDirecaoFromInspector(int di) {
        if (di == 0) {
            this.setDirecao(FormaNaoRetangularBase.Direcao.Left);
        } else {
            this.setDirecao(FormaNaoRetangularBase.Direcao.Right);
        }
    }

    private int getDirecaoForInspector() {
        if (this.getDirecao() == FormaNaoRetangularBase.Direcao.Left) {
            return 0;
        }
        return 1;
    }

    public int getCardMaxima() {
        return this.cardMaxima;
    }

    public void setCardMaxima(int cardMaxima) {
        if (cardMaxima == 0 || cardMaxima < -1) {
            cardMaxima = 1;
        }
        if (this.cardMaxima != cardMaxima) {
            this.cardMaxima = cardMaxima;
            if (this.cardMinima > cardMaxima && cardMaxima != -1) {
                this.setCardMinima(cardMaxima);
            }
            this.InvalidateArea();
        }
    }

    public int getCardMinima() {
        return this.cardMinima;
    }

    public void setCardMinima(int cardMinima) {
        if (cardMinima < -1) {
            cardMinima = 0;
        }
        if (this.cardMinima != cardMinima) {
            this.cardMinima = cardMinima;
            if (cardMinima > this.cardMaxima && this.cardMaxima != -1) {
                this.cardMaxima = cardMinima == 0 ? 1 : cardMinima;
            }
            if (this.cardMinima == 0) {
                this.setOpcional(true);
            } else {
                this.setOpcional(false);
            }
            this.InvalidateArea();
        }
    }

    @Override
    public void setOpcional(boolean opcional) {
        super.setOpcional(opcional);
        if (opcional && this.cardMinima != 0) {
            this.cardMinima = 0;
        } else if (!opcional && this.cardMinima == 0) {
            this.setCardMinima(1);
        }
    }

    public boolean isMultivalorado() {
        return this.multivalorado;
    }

    public void setMultivalorado(boolean multivalorado) {
        if (this.multivalorado != multivalorado) {
            this.multivalorado = multivalorado;
            if (this.isMultivalorado()) {
                if (this.cardMinima == 0) {
                    this.setOpcional(true);
                } else {
                    this.setOpcional(false);
                }
            }
            this.InvalidateArea();
        }
    }

    public String getTipoAtributo() {
        return this.tipoAtributo;
    }

    public void setTipoAtributo(String tipo) {
        this.tipoAtributo = tipo;
    }

    public String getCardMinFromString() {
        int res = this.getCardMinima();
        String s = String.valueOf(res);
        if (res == -1) {
            s = "n";
        }
        return s;
    }

    public String getCardMaxFromString() {
        int res = this.getCardMaxima();
        String s = String.valueOf(res);
        if (res == -1) {
            s = "n";
        }
        return s;
    }

    public void setCardMinFromString(String valor) {
        this.setCard(valor, false);
    }

    public void setCardMaxFromString(String valor) {
        this.setCard(valor, true);
    }

    public void setCard(String vl, boolean max) {
        if (vl.toLowerCase().equals("n")) {
            vl = "-1";
        }
        int valor = -1;
        try {
            valor = Integer.valueOf(vl);
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_SET_CARD", e.getMessage());
        }
        if (valor < -1) {
            BrLogger.Logger("ERROR_SET_CARD", "INVALID!");
            valor = -1;
        }
        if (max) {
            this.setCardMaxima(valor);
        } else {
            this.setCardMinima(valor);
        }
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactoryMenu("direcao", "setDirecaoFromInspector", this.getDirecaoForInspector(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdAtributo)));
        res.add(InspectorProperty.PropertyFactorySN("atributo.autosize", "setAutosize", this.isAutosize()));
        res.add(InspectorProperty.PropertyFactorySeparador("esquema"));
        res.add(InspectorProperty.PropertyFactorySN("atributo.identificador", "setIdentificador", this.isIdentificador()));
        res.add(InspectorProperty.PropertyFactorySN("atributo.opcional", "setOpcional", this.isOpcional()));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraSN("atributo.composto", this.isAtributoComposto()));
        res.add(InspectorProperty.PropertyFactorySN("atributo.multivalorado", "setMultivalorado", this.isMultivalorado()).AddCondicaoForTrue(new String[]{"setCardMinFromString", "setCardMaxFromString"}).AddCondicaoForFalse(new String[]{"setOpcional"}));
        res.add(InspectorProperty.PropertyFactoryTexto("atributo.cardinalidademinima", "setCardMinFromString", this.getCardMinFromString()));
        res.add(InspectorProperty.PropertyFactoryTexto("atributo.cardinalidademaxima", "setCardMaxFromString", this.getCardMaxFromString()));
        res.add(InspectorProperty.PropertyFactoryTexto("atributo.tipoatributo", "setTipoAtributo", this.getTipoAtributo()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "entidade.orgattr").setTag(123));
        return res;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorInteger(doc, "DirecaoFromInspector", this.getDirecaoForInspector()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Autosize", this.isAutosize()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Identificador", this.isIdentificador()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Opcional", this.isOpcional()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Multivalorado", this.isMultivalorado()));
        me.appendChild(XMLGenerate.ValorString(doc, "CardMinFromString", this.getCardMinFromString()));
        me.appendChild(XMLGenerate.ValorString(doc, "CardMaxFromString", this.getCardMaxFromString()));
        me.appendChild(XMLGenerate.ValorString(doc, "TipoAtributo", this.getTipoAtributo()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        int l = XMLGenerate.getValorIntegerFrom(me, "DirecaoFromInspector");
        if (l != -1) {
            this.setDirecaoFromInspector(l);
        }
        this.setAutosize(XMLGenerate.getValorBooleanFrom(me, "Autosize"));
        this.setIdentificador(XMLGenerate.getValorBooleanFrom(me, "Identificador"));
        this.setOpcional(XMLGenerate.getValorBooleanFrom(me, "Opcional"));
        this.setMultivalorado(XMLGenerate.getValorBooleanFrom(me, "Multivalorado"));
        this.setCardMinFromString(XMLGenerate.getValorStringFrom(me, "CardMinFromString"));
        this.setCardMaxFromString(XMLGenerate.getValorStringFrom(me, "CardMaxFromString"));
        this.setTipoAtributo(XMLGenerate.getValorStringFrom(me, "TipoAtributo"));
        return true;
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 123) {
            PontoDeLinha pp = this.PontoLigacaoPrincipal(null);
            List<Atributo> pts = this.getListaDePontosLigados().stream().filter(p -> p != pp && p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).map(p -> (Atributo)p.getDono().getOutraPonta((PontoDeLinha)p).getEm()).collect(Collectors.toList());
            boolean ja = this.Alinhe(pts);
            for (Atributo att : pts) {
                if (!att.OrganizeAtributos()) continue;
                ja = true;
            }
            if (ja) {
                this.DoMuda();
            }
        }
    }

    private boolean Alinhe(List<Atributo> atrs) {
        if (atrs.isEmpty()) {
            return false;
        }
        int distH = 5;
        int H = atrs.stream().mapToInt(a -> a.getHeight()).sum() + (atrs.size() - 1) * distH;
        int T = this.getTop() - H / 2 + this.getHeight() / 2;
        int distW = 40;
        boolean res = false;
        if (this.getDirecaoLigacao() == FormaNaoRetangularBase.Direcao.Left) {
            int L = this.getLeftWidth() + distW;
            for (Atributo a2 : atrs) {
                if (this.getMaster().getItensSelecionados().indexOf(a2) > -1) {
                    T += a2.getHeight() + distH;
                    continue;
                }
                a2.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
                res = this.alteraLeftTop(a2, L, T);
                T += a2.getHeight() + distH;
            }
        } else {
            for (Atributo a3 : atrs) {
                if (this.getMaster().getItensSelecionados().indexOf(a3) > -1) {
                    T += a3.getHeight() + distH;
                    continue;
                }
                int L = this.getLeft() - distW - a3.getWidth();
                a3.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Right);
                res = this.alteraLeftTop(a3, L, T);
                T += a3.getHeight() + distH;
            }
        }
        return res;
    }

    public boolean OrganizeAtributos() {
        PontoDeLinha pp = this.PontoLigacaoPrincipal(null);
        List<Atributo> pts = this.getListaDePontosLigados().stream().filter(p -> p != pp && p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).map(p -> (Atributo)p.getDono().getOutraPonta((PontoDeLinha)p).getEm()).collect(Collectors.toList());
        boolean ja = this.Alinhe(pts);
        for (Atributo att : pts) {
            if (!att.OrganizeAtributos()) continue;
            ja = true;
        }
        return ja;
    }

    private boolean alteraLeftTop(Atributo a, int L, int T) {
        int l = a.getLeft() - L;
        int t = a.getTop() - T;
        if (l != 0 || t != 0) {
            Rectangle r = new Rectangle(l, t, 0, 0);
            a.ReciveFormaResize(r);
            a.Reenquadre();
            return true;
        }
        return false;
    }

    public List<Atributo> getAtributos() {
        PontoDeLinha pp = this.PontoLigacaoPrincipal(null);
        List<Atributo> lst = this.getListaDePontosLigados().stream().filter(p -> p != pp && p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).map(p -> (Atributo)p.getDono().getOutraPonta((PontoDeLinha)p).getEm()).collect(Collectors.toList());
        return lst;
    }

    @Override
    public String getTextoToDraw() {
        return super.getTexto() + (this.isMultivalorado() ? " (" + this.getCardMinFromString() + ", " + this.getCardMaxFromString() + ")" : "");
    }

    @Override
    public boolean isAlinhavel() {
        return false;
    }

    @Override
    public void runAncorasCode(int cod) {
        super.runAncorasCode(cod);
        if (cod == 2) {
            this.DoAnyThing(123);
        }
    }

    @Override
    public String WhatDrawOnAcorador(Integer c) {
        if (c == 2) {
            return "diagrama.ancordor.2.img";
        }
        return super.WhatDrawOnAcorador(c);
    }
}

