/*
 * Decompiled with CFR 0.152.
 */
package controlador.inspector;

import controlador.inspector.Inspector;
import controlador.inspector.InspectorItemBase;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class InspectorItemSeparador
extends InspectorItemBase {
    public boolean endOFF = false;
    private char estado = (char)45;

    public InspectorItemSeparador(Inspector criador) {
        super(criador);
        Color c = this.getBackground();
        c = new Color(c.getRed(), c.getGreen(), c.getBlue() - 15 > 0 ? c.getBlue() - 15 : 0);
        this.setBackground(c);
    }

    public InspectorItemSeparador() {
        Color c = this.getBackground();
        c = new Color(c.getRed(), c.getGreen(), c.getBlue() - 15 > 0 ? c.getBlue() - 15 : 0);
        this.setBackground(c);
    }

    @Override
    protected void paintBase(Graphics2D g) {
        if (this.endOFF) {
            return;
        }
        this.setArea(null);
        Rectangle r = this.getBounds();
        g.setColor(Color.GRAY);
        g.drawRoundRect(0, 0, r.width - 1, r.height - 1, 10, 10);
        g.setColor(Color.lightGray);
        g.drawRoundRect(5, 5, r.height - 10, r.height - 10, 4, 4);
        int met = (r.height - 11) / 2;
        g.setColor(Color.black);
        g.drawLine(7, 6 + met, r.height - 7, 6 + met);
        if ('+' == this.getEstado()) {
            g.drawLine(6 + met, 7, 6 + met, r.height - 7);
        }
        g.setColor(Color.BLACK);
        Rectangle bkp = g.getClipBounds();
        g.clipRect(0, 0, r.width - 1, r.height);
        if (this.isSelecionado()) {
            g.setFont(new Font(this.getFont().getFontName(), 1, this.getFont().getSize()));
            g.drawRoundRect(0, 0, r.width - 1, r.height - 1, 10, 10);
        }
        int tmp = (r.width - g.getFontMetrics().stringWidth(this.getTexto())) / 2;
        g.drawString(this.getTexto(), tmp, (int)((double)r.height * 0.72));
        g.setClip(bkp);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.endOFF) {
            return;
        }
        super.mousePressed(e);
        Rectangle r = this.getBounds();
        r = new Rectangle(5, 5, r.height - 10, r.height - 10);
        if (!r.contains(e.getPoint())) {
            return;
        }
        if ('+' == this.getEstado()) {
            this.setEstado('-');
        } else {
            this.setEstado('+');
        }
        this.Criador.HideShow(this, this.getEstado());
    }

    public char getEstado() {
        return this.estado;
    }

    public void setEstado(char estado) {
        if (this.estado != estado) {
            this.estado = estado;
            this.repaint();
        }
    }
}

