/*
 * Decompiled with CFR 0.152.
 */
package controlador.inspector;

import controlador.Editor;
import controlador.inspector.InspectorDicas;
import controlador.inspector.InspectorExtenderEditor;
import controlador.inspector.InspectorItemBase;
import controlador.inspector.InspectorItemExtender;
import controlador.inspector.InspectorItemMenu;
import controlador.inspector.InspectorItemSN;
import controlador.inspector.InspectorItemSeparador;
import controlador.inspector.InspectorItemTexto;
import controlador.inspector.InspectorProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Inspector
extends JScrollPane {
    private JPanel box;
    private ArrayList<InspectorItemBase> Itens = new ArrayList();
    public final int espaco = 1;
    public int altura = 20;
    protected final JComboBox TipoMenu = new JComboBox();
    protected final JCheckBox TipoSN = new JCheckBox();
    protected final InspectorExtenderEditor TipoDlg = new InspectorExtenderEditor(this);
    protected final JTextField TipoTexto = new JTextField();
    private Editor editor = null;
    private InspectorItemBase selecionado = null;
    private InspectorDicas dicas = null;
    private boolean stopEdicao = false;
    private ArrayList<InspectorProperty> gerado = null;
    private double divisor = 0.5;

    public Inspector() {
        this.Init();
    }

    private void Init() {
        this.box = new JPanel();
        this.add(this.box);
        this.box.setSize(300, 800);
        this.setViewportView(this.box);
        this.box.setLayout(null);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(31);
        this.getHorizontalScrollBar().setBlockIncrement(100);
        this.getVerticalScrollBar().setBlockIncrement(100);
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getVerticalScrollBar().setUnitIncrement(10);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Inspector.this.DoResize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setFocusable(true);
        ActionListener al_down = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.SelectNext(false);
            }
        };
        ActionListener al_up = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.SelectNext(true);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(40, 0);
        this.registerKeyboardAction(al_down, stroke, 1);
        stroke = KeyStroke.getKeyStroke(39, 0);
        this.registerKeyboardAction(al_down, stroke, 1);
        stroke = KeyStroke.getKeyStroke(38, 0);
        this.registerKeyboardAction(al_up, stroke, 1);
        stroke = KeyStroke.getKeyStroke(37, 0);
        this.registerKeyboardAction(al_up, stroke, 1);
        this.InitEditores();
    }

    private void InitEditores() {
        this.TipoMenu.setVisible(false);
        this.TipoTexto.setVisible(false);
        this.TipoSN.setVisible(false);
        this.TipoMenu.setEditable(true);
        this.TipoDlg.setVisible(false);
        this.TipoMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Inspector.this.EndEdit(true, false);
                }
            }
        });
        this.TipoSN.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Inspector.this.EndEdit(true, false);
            }
        });
        this.TipoTexto.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    Inspector.this.EndEdit(false, false);
                } else if (e.getKeyCode() == 10) {
                    Inspector.this.EndEdit(true, false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.TipoTexto.setBorder(null);
    }

    public void DoResize() {
        int scrollw = this.getVerticalScrollBar().getWidth() + 1;
        int tam = this.getWidth() - 2 - scrollw;
        Dimension d = new Dimension(tam, this.altura);
        for (InspectorItemBase item : this.Itens) {
            item.setPreferredSize(d);
            item.setSize(d);
            item.repaint();
        }
    }

    public JPanel getBox() {
        return this.box;
    }

    public ArrayList<InspectorItemBase> getItens() {
        return this.Itens;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public InspectorItemBase Add(InspectorProperty pprt) {
        if (pprt.tipo == InspectorProperty.TipoDeProperty.tpNothing) {
            return null;
        }
        int p = this.Itens.size() * (this.altura + 1);
        InspectorItemBase item = InspectorItemBase.SuperFactory(this, pprt);
        int scrollw = this.getVerticalScrollBar().getWidth() + 1;
        item.setBounds(1, p + 2, this.getWidth() - 2 - scrollw, this.altura);
        this.box.add(item);
        this.Itens.add(item);
        this.box.validate();
        return item;
    }

    public InspectorItemBase AddSeparador(String caption) {
        return this.Add(InspectorProperty.getPropertySeparador(caption));
    }

    public InspectorItemBase getSelecionado() {
        return this.selecionado;
    }

    private void setSelecionado(InspectorItemBase selecionado) {
        if (this.selecionado != selecionado) {
            if (this.selecionado != null) {
                this.selecionado.setSelecionado(false);
            }
            this.selecionado = selecionado;
            if (this.selecionado != null) {
                this.selecionado.setSelecionado(true);
            }
        }
        if (this.getDicas() == null) {
            if (this.selecionado != null) {
                this.editor.setTextoDica(this, selecionado.getPropriedade().dica);
            } else {
                this.editor.setTextoDica(this, "");
            }
        } else if (this.selecionado != null) {
            this.SetTextoDica(selecionado.getPropriedade().dica);
        } else {
            this.SetTextoDica("");
        }
    }

    public void SetTextoDica(String txt) {
        if (this.getDicas() != null) {
            this.getDicas().setTexto(txt);
        }
    }

    public void PerformSelect(InspectorItemBase aThis) {
        this.CarregueValor(aThis);
        this.setSelecionado(aThis);
    }

    public void PerformDica() {
        if (this.getDicas() != null) {
            if (this.selecionado != null) {
                this.SetTextoDica(this.selecionado.getPropriedade().dica);
            } else {
                this.SetTextoDica("");
            }
        } else if (this.editor != null) {
            if (this.selecionado != null) {
                this.editor.setTextoDica(this, this.selecionado.getPropriedade().dica);
            } else {
                this.editor.setTextoDica(this, "");
            }
        }
    }

    private void SelectNext(boolean sobe) {
        if (this.Itens.isEmpty()) {
            return;
        }
        int p = this.Itens.indexOf(this.selecionado);
        if (sobe) {
            if (--p < 0) {
                p = this.Itens.size() - 1;
            }
            InspectorItemBase ib = this.Itens.get(p);
            while (ib instanceof InspectorItemSeparador || !ib.CanEdit() || !ib.isVisible() || ib instanceof InspectorItemMenu) {
                if (--p < 0) {
                    return;
                }
                ib = this.Itens.get(p);
            }
            this.PerformSelect(this.Itens.get(p));
        } else {
            if (++p > this.Itens.size() - 1) {
                p = 0;
            }
            InspectorItemBase ib = this.Itens.get(p);
            while (ib instanceof InspectorItemSeparador || !ib.CanEdit() || !ib.isVisible() || ib instanceof InspectorItemMenu) {
                if (++p > this.Itens.size() - 1) {
                    return;
                }
                ib = this.Itens.get(p);
            }
            this.PerformSelect(this.Itens.get(p));
        }
    }

    public void EndEdit(boolean validar, boolean sair) {
        if (this.stopEdicao) {
            return;
        }
        if (!validar) {
            if (sair) {
                this.setSelecionado(null);
            } else {
                this.CarregueValor(this.selecionado);
            }
        } else {
            if (this.selecionado == null) {
                return;
            }
            String txt = "";
            if (this.selecionado.getOndeEditar() == this.TipoMenu) {
                txt = Integer.toString(this.TipoMenu.getSelectedIndex());
            } else if (this.selecionado.getOndeEditar() == this.TipoDlg) {
                if (this.selecionado.getPropriedade().tipo == InspectorProperty.TipoDeProperty.tpSelecObject) {
                    if (this.editor.SelectItemByID(Integer.valueOf(this.selecionado.getPropriedade().property))) {
                        return;
                    }
                    this.setSelecionado(null);
                    return;
                }
                if (this.selecionado.getPropriedade().tipo == InspectorProperty.TipoDeProperty.tpCommand) {
                    if (this.editor.ProcesseCmdFromInspector(this, this.selecionado.getPropriedade().property)) {
                        return;
                    }
                    this.setSelecionado(null);
                    return;
                }
                txt = this.TipoDlg.getTexto();
            } else {
                txt = this.selecionado.getOndeEditar() == this.TipoSN ? Boolean.toString(this.TipoSN.isSelected()) : this.TipoTexto.getText();
            }
            if (!txt.equals(this.selecionado.getValor()) && !this.editor.AceitaEdicao(this, this.selecionado.getPropriedade(), txt)) {
                this.selecionado.setFalhou(true);
            }
            if (sair) {
                this.setSelecionado(null);
            } else {
                this.CarregueValor(this.selecionado);
            }
        }
    }

    private void CarregueValor(InspectorItemBase aThis) {
        this.stopEdicao = true;
        if (aThis instanceof InspectorItemMenu) {
            this.TipoMenu.removeAllItems();
            for (String v : aThis.getPropriedade().opcoesMenu) {
                this.TipoMenu.addItem(v);
            }
            this.TipoMenu.setSelectedIndex(Integer.parseInt(aThis.getValor()));
        } else if (aThis instanceof InspectorItemExtender) {
            this.TipoDlg.setTexto(aThis.getTransValor());
        } else if (aThis instanceof InspectorItemSN) {
            this.TipoSN.setSelected(Boolean.parseBoolean(aThis.getValor()));
            this.TipoSN.setText(aThis.getTransValor());
        } else if (aThis instanceof InspectorItemTexto) {
            this.TipoTexto.setText(aThis.getTransValor());
        }
        this.stopEdicao = false;
    }

    public void Clear() {
        for (InspectorItemBase item : this.Itens) {
            this.box.remove(item);
        }
        this.Itens.clear();
        this.box.validate();
        this.RePosicionar();
        this.repaint();
    }

    public void ForceFullOnCarregue() {
        this.gerado.clear();
    }

    public void Carrege(ArrayList<InspectorProperty> conjPropriedades) {
        boolean eq = false;
        if (this.gerado != null && this.gerado.size() == conjPropriedades.size()) {
            eq = true;
            for (int i = 0; i < this.gerado.size(); ++i) {
                if (this.gerado.get((int)i).tipo.equals((Object)conjPropriedades.get((int)i).tipo)) continue;
                eq = false;
                break;
            }
        }
        boolean novo = false;
        if (eq) {
            for (int i = 0; i < this.gerado.size(); ++i) {
                InspectorItemBase it = this.Itens.get(i);
                it.setPropriedade(conjPropriedades.get(i));
                it.repaint();
            }
            if (this.selecionado != null) {
                this.CarregueValor(this.selecionado);
            }
        } else {
            this.Clear();
            conjPropriedades.stream().forEach(ipp -> this.Add((InspectorProperty)ipp));
            InspectorItemBase tmp = this.AddSeparador("");
            ((InspectorItemSeparador)tmp).endOFF = true;
            tmp.setBackground(new Color(240, 240, 240));
            novo = true;
        }
        this.gerado = conjPropriedades;
        this.RefreshAllCanEdit();
        if (novo) {
            this.Itens.stream().filter(pp -> pp instanceof InspectorItemSeparador).map(pp -> (InspectorItemSeparador)pp).forEach(pp -> {
                if (pp.getPropriedade().opcional.equals("-")) {
                    pp.setEstado('+');
                    this.HideShow((InspectorItemSeparador)pp, '+');
                }
            });
        }
        this.RePosicionar();
    }

    private ArrayList<InspectorItemBase> getListItensForProperty(ArrayList<String> pprs) {
        ArrayList<InspectorItemBase> res = new ArrayList<InspectorItemBase>();
        pprs.stream().forEach(v -> this.getItens().stream().filter(it -> it.getPropriedade().isMe((String)v)).forEach(it -> res.add((InspectorItemBase)it)));
        return res;
    }

    public void MakeCanEditGrupo(InspectorItemBase sel) {
        InspectorProperty insp = sel.getPropriedade();
        if (insp.agrupada == null) {
            return;
        }
        String valor = sel.getValor();
        this.MakeCanEdit(this.getListItensForProperty(insp.QuaisCanEditIf(valor)), true);
        this.MakeCanEdit(this.getListItensForProperty(insp.QuaisCanEditNotIf(valor)), false);
        this.repaint();
    }

    private void MakeCanEdit(ArrayList<InspectorItemBase> toMake, boolean ena) {
        if (ena) {
            toMake.stream().forEach(it -> it.setCanEdit(true));
            toMake.stream().forEach(it -> it.RefreshGrupoCanEdit());
        } else {
            toMake.stream().forEach(it -> it.setCanEdit(false));
        }
    }

    public void RefreshAllCanEdit() {
        for (InspectorItemBase it : this.getItens()) {
            it.RefreshGrupoCanEdit();
        }
        this.revalidate();
    }

    public InspectorDicas getDicas() {
        return this.dicas;
    }

    public void setDicas(InspectorDicas dicas) {
        this.dicas = dicas;
    }

    public void HideShow(InspectorItemSeparador item, char estado) {
        int i = this.getItens().indexOf(item);
        if ('+' == estado) {
            for (int j = i + 1; j < this.gerado.size(); ++j) {
                if (this.gerado.get((int)j).tipo == InspectorProperty.TipoDeProperty.tpSeparador) {
                    this.RePosicionar();
                    return;
                }
                this.getItens().get(j).setVisible(false);
            }
        } else {
            for (int j = i + 1; j < this.gerado.size(); ++j) {
                if (this.gerado.get((int)j).tipo == InspectorProperty.TipoDeProperty.tpSeparador) {
                    this.RePosicionar();
                    return;
                }
                this.getItens().get(j).setVisible(true);
            }
        }
        this.RePosicionar();
    }

    public void RePosicionar() {
        this.box.removeAll();
        int tl = 0;
        int scrollw = this.getVerticalScrollBar().getWidth() + 1;
        for (InspectorItemBase item : this.getItens()) {
            if (!item.isVisible()) continue;
            int p = tl * (this.altura + 1);
            ++tl;
            item.setPreferredSize(new Dimension(this.getWidth() - 2 - scrollw, this.altura));
            this.box.add(item);
            item.setLocation(1, p + 2);
        }
        this.box.setSize(this.box.getSize().width, tl * (this.altura + 1));
        this.box.setPreferredSize(this.box.getSize());
    }

    public InspectorItemBase FindByProperty(String pprt) {
        for (InspectorItemBase it : this.getItens()) {
            if (!it.getPropriedade().isMe(pprt)) continue;
            return it;
        }
        return null;
    }

    @Override
    public void paint(Graphics grphcs) {
        super.paint(grphcs);
        Graphics2D g = (Graphics2D)grphcs;
        int f = g.getFontMetrics().getHeight();
        if (this.altura != f + 6) {
            this.altura = f + 6;
        }
    }

    public double getDivisor() {
        return this.divisor;
    }

    public void setDivisor(double divisor) {
        this.divisor = divisor;
        this.DoResize();
    }
}

