/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.BaseControlador;
import controlador.Diagrama;
import controlador.Editor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class Mostrador
extends BaseControlador {
    private Editor master;
    private final ArrayList<Rectangle> areas = new ArrayList();
    private final int larg = 130;
    private final int largPonta = 10;
    private final int dist = 2;
    private final int tabRecuo = 12;
    private final int mover = 20;
    private int scroll = 12;
    private int selectedIndex = 0;
    public static final String Img = "Controler.interface.mostrador.fechar.img";
    private Rectangle regFechar = null;
    private int fh = -1;
    private Rectangle overRNow = null;

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.Construa();
        if (this.areas.isEmpty() || selectedIndex == -1) {
            return;
        }
        this.setTableVisible(selectedIndex);
    }

    public ArrayList<Diagrama> getDiagramas() {
        if (this.master != null) {
            return this.master.getDiagramas();
        }
        return null;
    }

    public Editor getMaster() {
        return this.master;
    }

    public void setMaster(Editor master) {
        this.master = master;
    }

    public void Reset(int selIdex) {
        this.setSelectedIndex(selIdex);
        this.repaint();
    }

    public void Construa() {
        this.areas.clear();
        if (this.getDiagramas() == null) {
            return;
        }
        this.areas.add(new Rectangle(0, 0, 10, this.getHeight() - 1));
        this.areas.add(new Rectangle(this.getWidth() - 10, 0, 10, this.getHeight() - 1));
        int y = 0;
        int sx = this.scroll;
        for (Diagrama m : this.getDiagramas()) {
            this.areas.add(new Rectangle(sx, y, 130, this.getHeight() - y));
            sx += 132;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.regFechar = null;
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(renderHints);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        if (this.fh == -1) {
            FontMetrics fm = g2.getFontMetrics();
            this.fh = fm.getHeight() - fm.getDescent();
        }
        this.Construa();
        if (this.areas.isEmpty()) {
            return;
        }
        g2.setColor(new Color(204, 204, 255));
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g2.setColor(Color.gray);
        int imgw = 22;
        int i = 1;
        int txL = this.getHeight() / 2 + this.fh / 2;
        for (Diagrama m : this.getDiagramas()) {
            g2.setColor(Color.gray);
            Rectangle r = this.areas.get(++i);
            boolean esse = false;
            if (this.overRNow != null && this.overRNow.equals(r)) {
                esse = true;
            }
            if (this.selectedIndex == i - 2) {
                r = new Rectangle(r.x, r.y + 2, r.width, r.height);
                g2.setColor(new Color(204, 204, 255));
                g2.drawRect(r.x - 1, r.y - 1, r.width + 1, r.height);
                g2.setColor(Color.WHITE);
                g2.fill(r);
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(new Color(204, 204, 255));
                g2.drawRect(r.x, r.y, r.width, r.height - 1);
                if (this.overRNow != null && this.overRNow.equals(r)) {
                    g2.setColor(Color.WHITE);
                    g2.fill(new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 3));
                }
                g2.setColor(Color.gray);
            }
            g2.drawImage(this.master.getControler().ImagemDeDiagrama.get(m.getTipo().name()).getImage(), r.x + 2, r.y + this.fh / 2, null);
            Rectangle bkp = g.getClipBounds();
            g2.clipRect(r.x, r.y, r.width, r.height);
            String tmp = (m.getMudou() ? "*" : "") + m.getNomeFormatado();
            int tamtxt = g.getFontMetrics().stringWidth(tmp);
            if (tamtxt > r.width - imgw) {
                tmp = tmp.substring(0, tmp.length() - 3) + "...";
                tamtxt = g.getFontMetrics().stringWidth(tmp);
                while (tamtxt > r.width - imgw) {
                    tmp = tmp.substring(0, tmp.length() - 4) + "...";
                    tamtxt = g.getFontMetrics().stringWidth(tmp);
                }
            }
            g2.drawString(tmp, imgw + r.x, r.y + txL);
            g2.setClip(bkp);
            if (!esse && (this.overRNow == null || !this.overRNow.equals(r))) continue;
            g2.setColor(Color.WHITE);
            this.regFechar = new Rectangle(r.x + r.width - 18, r.y + this.fh / 2, 16, 16);
            g2.fillRect(this.regFechar.x - 2, this.regFechar.y - 2, 20, 20);
            g2.drawImage(this.master.getControler().ImagemDeDiagrama.get(Img).getImage(), r.x + r.width - 18, r.y + this.fh / 2 - 1, null);
        }
        g2.setColor(this.getBackground());
        Rectangle r1 = this.areas.get(0);
        g2.fill(r1);
        Rectangle r2 = this.areas.get(1);
        g2.fill(r2);
        int len = this.getHeight() / 2;
        int ARR_SIZE = 8;
        int l = 8;
        int ini = 2;
        if (this.overRNow != null && this.overRNow.equals(r1) && this.scroll < 12) {
            g2.setColor(Color.RED);
        } else if (this.scroll < 12) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
        }
        g2.fillPolygon(new int[]{ini, l + ini, l + ini, ini}, new int[]{len, len - ARR_SIZE, len + ARR_SIZE, len}, 4);
        int tam = (this.areas.size() - 2) * 132 + 20 - 2 - this.getWidth();
        if (this.overRNow != null && this.overRNow.equals(r2) && tam > this.scroll * -1) {
            g2.setColor(Color.RED);
        } else if (tam > this.scroll * -1) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
        }
        g2.fillPolygon(new int[]{this.getWidth() - ini, this.getWidth() - ini - l, this.getWidth() - ini - l, this.getWidth() - ini}, new int[]{len, len - ARR_SIZE, len + ARR_SIZE, len}, 4);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.setOverNow(null);
    }

    public Rectangle getOverNow() {
        return this.overRNow;
    }

    public void setOverNow(Rectangle overNow) {
        if (this.overRNow == overNow) {
            return;
        }
        if (this.overRNow != null && this.overRNow.equals(overNow)) {
            return;
        }
        if (this.overRNow != null) {
            this.repaint(this.overRNow);
        }
        this.overRNow = overNow;
        if (this.overRNow != null) {
            this.repaint(this.overRNow);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        Point p = e.getPoint();
        this.ChecaCursor(p);
    }

    private void ChecaCursor(Point p) {
        if (this.areas.isEmpty()) {
            return;
        }
        int i = 0;
        for (Rectangle r : this.areas) {
            if (r.contains(p)) {
                this.setOverNow(r);
                if (i > 1) {
                    Rectangle r2 = new Rectangle(r.x + r.width - 18, r.y + this.fh / 2, 16, 16);
                    if (r2.contains(p)) {
                        this.setCursor(new Cursor(12));
                    } else {
                        this.setCursor(new Cursor(0));
                    }
                }
                return;
            }
            ++i;
        }
        this.setOverNow(null);
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.areas.isEmpty()) {
            return;
        }
        int i = 0;
        for (Rectangle r : this.areas) {
            if (r.contains(e.getPoint())) {
                Rectangle r2 = new Rectangle(r.x + r.width - 18, r.y + this.fh / 2, 16, 16);
                this.ProcessClick(i);
                if (i <= 1 || !r2.contains(e.getPoint())) break;
                this.master.FechaDiagrama(i - 2);
                this.Construa();
                this.ChecaCursor(e.getPoint());
                this.repaint();
                break;
            }
            ++i;
        }
        e.consume();
    }

    private void ProcessClick(int i) {
        if (i == 0 || i == 1) {
            if (i == 0) {
                if (this.scroll < 12) {
                    this.scroll += 20;
                    this.repaint();
                }
                return;
            }
            int tam = (this.areas.size() - 2) * 132 + 20 - 2 - this.getWidth();
            if (tam > this.scroll * -1) {
                this.scroll -= 20;
                this.repaint();
                return;
            }
            return;
        }
        this.setSelectedIndex(i - 2);
        if (this.master != null) {
            this.master.AtiveDiagrama(this.selectedIndex);
        }
    }

    private void setTableVisible(int idx) {
        if (this.areas == null || this.areas.isEmpty() || idx < 0) {
            return;
        }
        if (this.areas.size() - 2 > idx) {
            Rectangle r = this.areas.get(idx + 2);
            if (r.x + r.width > this.getWidth() - 12) {
                int calc = r.x + r.width - (this.getWidth() - 12);
                int tmp = Math.abs(calc % 20);
                if (tmp > 0) {
                    calc += 20 - Math.abs(calc % 20);
                }
                this.scroll -= calc;
                this.repaint();
            } else if (r.x < 12) {
                int calc = 12 - r.x;
                int tmp = Math.abs(calc % 20);
                if (tmp > 0) {
                    calc += 20 - Math.abs(calc % 20);
                }
                this.scroll += calc;
                this.repaint();
            }
        }
    }
}

